/*
   This program demonstrates the Java API for creating a process
   and passing it some environment variables.

   See
      http://docs.oracle.com/javase/6/docs/api/java/lang/Runtime.html#getRuntime()
      http://docs.oracle.com/javase/6/docs/api/java/lang/Runtime.html#method_summary
*/
import java.util.Scanner;
import java.io.*;

public class RunProgramWithParameters
{
   public static void main(String[] args) throws IOException, InterruptedException
   {
      // Create a ProcessBuilder object for running EnvironmentVariables.class
      ProcessBuilder pb = new ProcessBuilder("java", "EnvironmentVariables", "a", "b", "c", "d");

      // Pass arguments to EnvironmentVariables by using environment variables.
      pb.environment().put( "a", "first" );
      pb.environment().put( "b", "second" );
      pb.environment().put( "c", "third" );

      // "call" EnvironmentVariables.class
      Process p = pb.start();
      // wait for the "call" to return
      p.waitFor();
      // NOTE: There is no output from running this program.
      //       It should print output on the console screen,
      //       but it does not. This is one of the problems
      //       with having Java start up processes.
   }
}